/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.command.UndoableCommand;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.MrpAlgorithms;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.mrp4.Mrp;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.planning.mokos.MaterialBoundUpdater;
import cz.insophy.inplan.planning.mokos.MokosRunner;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.CalendarHelper;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtpCommand
implements UndoableCommand {
    private static final Logger log = LoggerFactory.getLogger(CtpCommand.class);
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_CTP_PRIORITY = 9;
    private String productId;
    private String actiongramName;
    private double qty;
    private long releaseDate;
    private long dueDate;
    private int priority = 9;
    private Mode mode = Mode.DIRECT;
    private String crId;
    private List<String> generatedGors;
    private List<String> generatedSrs;
    private boolean defaultMinBatch = false;
    private boolean defaultMaxBatch = false;
    private boolean defaultBatchStep = false;
    private String currentResult = "";
    private String lastResult = "";

    @Override
    public String getDescription() {
        Object description = "";
        description = this.mode == Mode.DIRECT ? (String)description + Localizer.getString("command.ctp.desc", this.crId, this.productId, this.qty, new Date(this.dueDate)) : (String)description + Localizer.getString("command.ctp.desc_cdq", this.productId, new Date(this.dueDate));
        if (this.currentResult != null && !this.currentResult.isEmpty()) {
            description = (String)description + " - " + Localizer.getString("command.ctp.result_current", this.currentResult);
        }
        if (this.lastResult != null && !this.lastResult.isEmpty()) {
            description = (String)description + " - " + Localizer.getString("command.ctp.result_last", this.lastResult);
        }
        return description;
    }

    private List<Problem> doExecute(Superplan superplan) {
        ArrayList<Problem> problems = Lists.newArrayList();
        ShopConfiguration conf = superplan.getShopConf();
        Product p = conf.getProduct(this.productId);
        if (p == null) {
            problems.add(Problem.createProblem("03200", null, null, false, this.productId));
            return problems;
        }
        if (this.qty <= 1.0E-7) {
            problems.add(Problem.createProblem("03250", null, null, false, this.qty));
            return problems;
        }
        if (this.crId == null) {
            this.crId = CtpCommand.generateCrId(superplan, p);
        } else if (superplan.getCustomerRequest(this.crId) != null) {
            String newCrId = CtpCommand.generateCrId(superplan, p);
            problems.add(Problem.createProblem("03300", null, null, false, this.crId, newCrId));
            this.crId = newCrId;
        }
        Actiongram ag = p.getActiongram(this.actiongramName);
        if (ag == null) {
            problems.add(Problem.createProblem("03325", null, null, false, this.actiongramName, this.productId));
            return problems;
        }
        CustomerRequest cr = new CustomerRequest(this.crId, p, this.dueDate, this.qty, this.priority);
        superplan.addCustomerRequest(cr);
        if (!MrpAlgorithms.checkSanity(superplan, false)) {
            log.warn("Superplan is not sane from MRP perspective before running CTP. Expect strange things to happen.");
        }
        if (!(this.defaultBatchStep && this.defaultMinBatch && this.defaultMaxBatch)) {
            log.warn("CtpCommand does not support material batching. Ignoring settings.");
        }
        CtpMrp mrp = new CtpMrp(superplan);
        mrp.run();
        for (GeneralizedOrderRequest gor : superplan.getGors()) {
            gor.setUserSelected(false);
        }
        for (GeneralizedOrderRequest gor : mrp.newGors) {
            gor.setUserSelected(true);
        }
        try {
            MokosRunner runner = new MokosRunner();
            runner.setSuperplan(superplan);
            ((Scheduler)runner.getPlanningAlgorithm()).getProcessors(MaterialBoundUpdater.class).forEach(mbu -> mbu.setMatHorizonTreatment(StoreSchedule.MatHorizonTreatment.NO_HORIZONS));
            runner.run();
        }
        catch (Exception e) {
            problems.add(Problem.createProblem("03350", null, null, false, e.getLocalizedMessage()));
        }
        this.generatedGors = Lists.newArrayListWithCapacity(mrp.newGors.size());
        for (GeneralizedOrderRequest gor : mrp.newGors) {
            this.generatedGors.add(gor.getId());
        }
        this.generatedSrs = Lists.newArrayList();
        for (SupplyRequest sr : mrp.newSrs) {
            this.generatedSrs.add(sr.getId());
        }
        this.lastResult = this.currentResult;
        this.currentResult = this.getResult(mrp.newGors);
        return problems;
    }

    private String getResult(Collection<GeneralizedOrderRequest> gors) {
        Long maxDate = null;
        for (GeneralizedOrderRequest gor : gors) {
            if (!GeneralizedRequest.isDateValid(gor.getEndDate()) || maxDate != null && gor.getEndDate() <= maxDate) continue;
            maxDate = gor.getEndDate();
        }
        if (maxDate == null) {
            return Localizer.getString("command.ctp.result_no_date");
        }
        return Formatter.formatShortDateTime(maxDate);
    }

    private boolean isDelayed(Superplan superplan) {
        CustomerRequest cr = superplan.getCustomerRequest(this.crId);
        if (cr == null) {
            return true;
        }
        for (String gorId : this.generatedGors) {
            GeneralizedOrderRequest gor = superplan.getGor(gorId);
            if (gor != null && gor.getEndDate() <= cr.getTime()) continue;
            return true;
        }
        return false;
    }

    private void latestDueDate(Superplan superplan) {
        ShopConfiguration conf = superplan.getShopConf();
        Product p = conf.getProduct(this.productId);
        long latestDd = superplan.getFixationDate();
        if (p != null) {
            for (CustomerRequest cr : superplan.getCustomerRequests()) {
                if (!cr.getMaterial().getName().equals(this.productId) || cr.getTime() <= latestDd) continue;
                latestDd = cr.getTime();
            }
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(latestDd);
        c.add(6, 1);
        CalendarHelper.setDayStart(c);
        this.dueDate = c.getTimeInMillis();
    }

    private List<Problem> canDoQuoting(Superplan superplan) {
        List<Problem> problems = this.doExecute(superplan);
        if (this.isDelayed(superplan)) {
            int n;
            this.doUnexecute(superplan);
            double a = 0.0;
            double b = this.qty;
            boolean delayed = true;
            ArrayList<Tuple<Double, Boolean>> runLog = Lists.newArrayList();
            int MAX_ITER = 20;
            for (n = 0; n < 20; ++n) {
                this.qty = Math.floor((a + b) / 2.0);
                problems = this.doExecute(superplan);
                delayed = this.isDelayed(superplan);
                runLog.add(Tuple.create(this.qty, delayed));
                if (b - a <= 2.0) break;
                if (delayed) {
                    b = this.qty;
                } else {
                    a = this.qty;
                }
                this.doUnexecute(superplan);
            }
            if (delayed && a > 0.0) {
                if (n < 20) {
                    this.doUnexecute(superplan);
                }
                log.info("Retrying... for qty={}", (Object)a);
                this.qty = a;
                problems = this.doExecute(superplan);
                delayed = this.isDelayed(superplan);
            }
            if (delayed) {
                problems = Lists.newArrayList(Problem.createProblem("03400", null, null, false, new Date(this.dueDate), this.productId));
                this.doUnexecute(superplan);
                this.crId = null;
                this.generatedGors = null;
                this.generatedSrs = null;
            } else {
                this.mode = Mode.DIRECT;
            }
            log.info("CTP CDQ bisection summary:\n" + Joiner.on('\n').join(runLog));
        } else {
            this.mode = Mode.DIRECT;
            log.info("Not doing bisection. Can handle the maximum qty {}.", (Object)this.qty);
        }
        return problems;
    }

    @Override
    public List<Problem> execute(Superplan superplan) {
        switch (this.mode) {
            case DIRECT: {
                return this.doExecute(superplan);
            }
            case CAN_DO_QUOTING: {
                return this.canDoQuoting(superplan);
            }
        }
        throw new IllegalStateException("Unexpected mode " + this.mode);
    }

    private static String generateCrId(Superplan superplan, Product p) {
        String crId;
        int i = 0;
        while (superplan.getCustomerRequest(crId = String.format("V_%s_%05d", p.getName(), ++i)) != null) {
        }
        return crId;
    }

    private List<Problem> doUnexecute(Superplan superplan) {
        ArrayList<Problem> problems = Lists.newArrayList();
        if (this.crId != null) {
            CustomerRequest cr = superplan.getCustomerRequest(this.crId);
            if (cr != null) {
                superplan.removeCustomerRequest(cr);
            } else {
                problems.add(Problem.createProblem("03450", null, null, false, this.crId));
            }
        } else {
            problems.add(Problem.createProblem("03500", null, null, false, new Object[0]));
        }
        if (this.generatedGors != null) {
            for (String gorId : this.generatedGors) {
                GeneralizedOrderRequest gor = superplan.getGor(gorId);
                if (gor != null) {
                    superplan.removeGor(gor);
                    continue;
                }
                problems.add(Problem.createProblem("03550", null, null, false, gorId));
            }
        } else {
            problems.add(Problem.createProblem("03600", null, null, false, new Object[0]));
        }
        if (this.generatedSrs != null) {
            for (String srId : this.generatedSrs) {
                SupplyRequest sr = superplan.getSupplyRequest(srId);
                if (sr != null) {
                    superplan.removeSupplyRequest(sr);
                    continue;
                }
                problems.add(Problem.createProblem("03650", null, null, false, srId));
            }
        } else {
            problems.add(Problem.createProblem("03700", null, null, false, new Object[0]));
        }
        RebuildPlannerUtils.fixAndRegister(superplan.getPlan());
        return problems;
    }

    @Override
    public List<Problem> unexecute(Superplan superplan) {
        if (this.mode == Mode.CAN_DO_QUOTING) {
            return Collections.emptyList();
        }
        return this.doUnexecute(superplan);
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setActiongram(String actiongramName) {
        this.actiongramName = actiongramName;
    }

    public double getQty() {
        return this.qty;
    }

    public void setQty(double qty) {
        this.qty = qty;
    }

    public long getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(long date) {
        this.dueDate = date;
    }

    public long getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(long date) {
        this.releaseDate = date;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (priority > 0 && priority <= 10) {
            this.priority = priority;
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = Preconditions.checkNotNull(mode);
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getCrId() {
        return this.crId;
    }

    public List<String> getGeneratedGors() {
        return this.generatedGors;
    }

    public List<String> getGeneratedSrs() {
        return this.generatedSrs;
    }

    public void setBatchFlags(boolean defaultMin, boolean defaultMax, boolean defaultStep) {
        this.defaultMinBatch = defaultMin;
        this.defaultMaxBatch = defaultMax;
        this.defaultBatchStep = defaultStep;
    }

    public static enum Mode {
        DIRECT,
        CAN_DO_QUOTING;

    }

    private static class CtpMrp
    extends Mrp {
        List<GeneralizedOrderRequest> newGors = new ArrayList<GeneralizedOrderRequest>();
        private List<SupplyRequest> newSrs = new ArrayList<SupplyRequest>();

        CtpMrp(@Nonnull Superplan superplan) {
            super(superplan);
        }

        @Override
        protected void run() {
            super.run();
        }

        @Override
        @Nonnull
        protected GeneralizedOrderRequest createGor(@Nonnull Mrp.ProductInfo info) {
            GeneralizedOrderRequest gor = super.createGor(info);
            gor.setState(GeneralizedOrderRequest.State.VIRTUAL);
            this.newGors.add(gor);
            return gor;
        }

        @Override
        protected SupplyRequest createSr(Mrp.MaterialInfo info) {
            SupplyRequest sr = super.createSr(info);
            sr.setState(SupplyRequest.State.VIRTUAL);
            this.newSrs.add(sr);
            return sr;
        }
    }
}

